#ifndef ZLG_CONFIG_INTF_H
#define ZLG_CONFIG_INTF_H

struct _Meta;
struct _Pair;
struct _Options;
struct _ConfigNode;

typedef struct _Meta Meta;
typedef struct _Pair Pair;
typedef struct _Options Options;
typedef struct _ConfigNode ConfigNode;

/**
 *  \struct Options
 * ڵmataĿѡ
 */
struct _Options
{
	/*! ѡ*/
	const char * type;

	/*! ѡֵ*/
	const char * value;

	/*! ѡϢ*/
	const char * desc;
};

/**
 *  \struct Meta
 * ڵmataϢ
 */
struct _Meta
{
	/*!  */
	const char * type;

	/*! ˵Ϣ */
	const char * desc;

	/*! ǷֻģȱʡΪɶд */
	int read_only;

	/*! ʽʾ */
	const char * format;

	/*! ֵ͵˵Сֵַ˵Сȣֽ */
	double min_value;

	/*! ֵ͵˵ֵַ˵󳤶ȣֽ */
	double max_value;

	/*! ĵλ */
	const char * unit;

	/*! ͨť/ֵȷʽ޸ʱ */
	double delta;

    /*! Ƿɼ, trueɼfalseɼҲ԰󶨱ʽʽʹòοdemo3ȱʡɼ */
    const char* visible;
    
    /*! Ƿʹ, trueʹܣfalseʹܣҲ԰󶨱ʽʽʹòοdemo3ȱʡʹ */
    const char* enable;

	/*! ĿѡֵtypeΪʱЧ */
	int editable;

	/*! ĿѡֵtypeΪʱЧNULL */
	Options** options;
};

/**
 *  \struct Pair
 *  ԵKeyValueԡ
 */
struct _Pair
{
	const char * key;
	const char * value;
};

/**
 *  \struct ConfigNode 
 *  ConfigNode
 */
struct _ConfigNode
{
	/*! ڵ */
	const char * name;
	/*! ڵֵ ͬ԰󶨱ʽ*/
	const char * value;
    /*! ڵֵıʽиñʽʱvalueɴ˱ʽ*/
    const char* binding_value;
	/*! ýڵ· */
	const char * path;
	/*! Ϣ */
	Meta* meta_info;
	/*! ýڵӽڵ, NULL*/
	ConfigNode** children;
	/*! ýڵ, NULL*/
	Pair** attributes;
};

/**
 * \brief ȡԵϢ
 *
 * \retval ConfigNode
 */
typedef const ConfigNode* (*GetPropertysFunc)();

/**
 * \brief ָ·Եֵ
 * \param[in] path  : Ե·
 * \param[in] value : Եֵ
 *
 * \retval ɹ1ʧܷ0
 */
typedef int (*SetValueFunc)(const char* path, const char* value);

/**
 * \brief ȡָ·Եֵ
 * \param[in] path  : Ե·
 * \retval ɹԵֵʧܷNULL
 */
typedef const char* (*GetValueFunc)(const char* path);

typedef struct  tagIProperty
{
	SetValueFunc     SetValue;
	GetValueFunc     GetValue;
	GetPropertysFunc GetPropertys;
}IProperty;

#endif/*ZLG_CONFIG_INTF_H*/

