import time
from pusican import Canopen_ku


def main():
    # 1. 连接设备
    # 格式：类型, IP:端口, 波特率, [节点ID列表]
    print("正在连接 CANET 设备...")
    driver = Canopen_ku('zlgcanet', '192.168.1.200:4001', baud1=125000, node_ids=[3])

    node_id = 3

    # 2. 设置运动参数 (PP模式 - 位置控制)
    # 设置工作模式为 4 (PP Mode - Point to Point)
    driver.set_work_mode(node_id, 4)

    # 设置最大速度
    driver.set_pp_speed(node_id, 100000)  # 设置最大速度

    # 3. 执行运动指令
    target_step = 20000  # 目标步数
    print(f"开始运动：目标 {target_step} 步")
    driver.set_pp_step(node_id, target_step)
    driver.set_pp_control_word(node_id, 16)

    # 模拟运行一段时间
    time.sleep(3)

    # 4. 读取实时状态
    pos = driver.read_motor_position(node_id)
    print(f"当前电机位置: {pos}")

    # 关闭连接
    driver.network.disconnect()
    print("连接已断开")


if __name__ == '__main__':
    main()
